# A list of interesting libraries I have starred on GitHub
from https://github.com/githubuser0xFFFF/GitHub-StarList/blob/main/README.md

## Table of Contents

- [Table of Contents](#table-of-contents)
- [Qt Libraries](#qt-libraries)
  - [GUI / Widgets](#gui--widgets)
  - [3D](#3d)
  - [QML](#qml)
  - [Network](#network)
  - [Database](#database)
  - [Miscellaneous](#miscellaneous)
- [Qt Applications](#qt-applications)
- [Raspberry Pi](#raspberry-pi)
- [Robotics](#robotics)
- [C / C++](#c--c)
- [Python](#python)
- [Software Development](#software-development)
- [Embedded](#embedded)
- [SiLA](#sila)
- [3D](#3d-1)


## Qt Libraries

### GUI / Widgets

- [QtPropertyBrowser](https://github.com/commontk/QtPropertyBrowser) - A property browser framework enabling the user to edit a set of properties.
- [qt5-node-editor](https://github.com/nwaniek/qt5-node-editor) - A Qt5 node editor written from scratch
- [NodeEditor](https://github.com/paceholder/nodeeditor) - Qt Node Editor. Dataflow programming framework. A general-purpose Qt-based library aimed at graph-controlled data processing.
- [QHexEdit2](https://github.com/Simsys/qhexedit2) - Binary Editor for Qt
- [TabToolbar](https://github.com/SeriousAlexej/TabToolbar) - A small library for creating tabbed toolbars (others may call it Ribbon)
- [JKQtExtras](https://github.com/jkriege2/JKQtExtras) - A collection of different Qt4 & Qt5 widgets
- [QSimpleScada](https://github.com/IndeemaSoftware/QSimpleScada) - Qt based simple SCADA framework, with dashboard, static and dynamic components 
- [QSkinny](https://github.com/uwerat/qskinny) - A lightweight framework on top of the Qt scene graph and only few classes from Qt/Quick. It is usable from C++ and/or QML. 
- [QtAwesome](https://github.com/gamecreature/QtAwesome) - Font Awesome support for Qt applications
- [longscroll-qt](https://github.com/TripleWhy/longscroll-qt) - Library to create really long scrollable widgets in Qt. Tested with millions of images.
- [QtSASS](https://github.com/spyder-ide/qtsass) - Compile SASS files to Qt stylesheets
- [Qt-Material](https://github.com/UN-GCPDS/qt-material) - Material inspired stylesheet for PySide6, PySide2 and PyQt5 with adjustable accent color (jinja)

### 3D

- [OculusQt3D](https://github.com/ComputationalPhysics/OculusQt3D) - Example of stereoscopic viewing for Oculus Rift with QML and Qt3D.
- [QtVtk](https://github.com/nicanor-romero/QtVtk) - An integration between Qt Quick Controls 2 and VTK for 3D rendering
- [Qt5Ogre21](https://github.com/Ybalrid/Qt5Ogre21) - Qt 5 integration for Ogre 2.1
- [coin3d](https://github.com/coin3d/coin) - Coin is an OpenGL- and scene graph based, 3D graphics library
- [Coindesigner](https://github.com/iocroblab/coindesigner) - Coindesigner is a RAD (rapid application development) system to build 3D applications using Coin3D openInventor.
- [VulkanSceneGraph](https://github.com/vsg-dev/VulkanSceneGraph) -VulkanSceneGraph (VSG), is a modern, cross platform, high performance scene graph library built upon Vulkan graphics/compute API.

### QML

### Network

- [QtNetworkNg](https://github.com/hgoldfish/qtnetworkng) - QtNetwork Next Generation. A coroutine based network framework for Qt/C++, with more simpler API than boost::asio.
- [Qt REST](https://github.com/qtrest/qtrest) - Qt / QML REST Client
- [QSsh](https://github.com/lvklabs/QSsh) - SSH and SFTP support for Qt. This project is based on Qt Creator's libQtcSsh.so

### Database

- [SQLATE](https://github.com/KDAB/sqlate) - Sqlate is a C++ library to interact with SQL databases that uses. It uses [Qt](https://www.qt.io) and advanced C++ templates that helps to write SQL queries in a type safe way, checked at compile time.
- [orm-qt](https://github.com/victorzhuk/orm-qt) - Object Relation Mapping with Qt library
- [Nut](https://github.com/HamedMasafi/Nut) - Advanced, Powerful and easy to use ORM for Qt 

### Miscellaneous

- [QtJsonSerializer](https://github.com/Skycoder42/QtJsonSerializer) - A library to perform generic seralization and deserialization of QObjects from and to JSON and CBOR
- [QJsonModel](https://github.com/dridk/QJsonModel) - Qt Json Tree Model
- [Qt-Inspector](https://github.com/robertknight/Qt-Inspector) - Utility to browse the Qt object tree of a running Qt application and edit object properties on the fly.
- [LimeReport](https://github.com/fralx/LimeReport) - Report generator for Qt Framework
- [qtcsv](https://github.com/iamantony/qtcsv) - Library for reading and writing csv-files in Qt.
- [QtMvvm](https://github.com/Skycoder42/QtMvvm) - A mvvm oriented library for Qt, to create Projects for Widgets and Quick in parallel
- [awesome-qt](https://github.com/JesseTG/awesome-qt) - A curated list of awesome tools, libraries, and resources for the Qt framework.
- [QSimpleUpdater](https://github.com/alex-spataru/QSimpleUpdater) - Updater system for Qt applications
- [QtAutoUpdater](https://github.com/Skycoder42/QtAutoUpdater) - A Qt library to automatically check for updates and install them
- [QtKeychain](https://github.com/frankosterfeld/qtkeychain) - Platform-independent Qt API for storing passwords securely.
- [QtSwissArmyKnife](https://github.com/qsaker/QtSwissArmyKnife) - QSAK (Qt Swiss Army Knife) is a multi-functional, cross-platform debugging tool based on Qt.
- [QtUsb](https://github.com/fpoussin/QtUsb) - A cross-platform USB Module for Qt.
- [Qtilities](https://github.com/JPNaude/Qtilities) - Building blocks for Qt applications
- [ixxatcan](https://github.com/gmarescotti/ixxatcan) - Qt CAN Plugin for IXXAT USB adapter
- [qModbusMaster](https://github.com/Thuzerland/qModbusMaster) - Fork of QModMaster (https://sourceforge.net/p/qmodmaster/code/ci/default/tree/) 
- [QtnProperty](https://github.com/qtinuum/QtnProperty) - Extended properties for Qt5 
- [QtVerbalExpressions](https://github.com/VerbalExpressions/QtVerbalExpressions) - This Qt lib is based off of the C++ VerbalExpressions library
- [pythonqt](https://github.com/MeVisLab/pythonqt) - Dynamic Python binding for Qt Applications
- [KDToolBox](https://github.com/KDAB/KDToolBox) - KDAB's collection of miscellaneous useful C++ classes and stuff for Qt applications.

## Qt Applications

- [QLdapEditor](https://github.com/Shcherbich/QLdapEditor) - LDAP Editor based on Qt and ldapc++ wrapper 
- [QVGE](https://github.com/ArsMasiuk/qvge) - Qt Visual Graph Editor
- [QssStylesheetEditor](https://github.com/hustlei/QssStylesheetEditor) - Editor for qt stylesheet (qss). Real-time preview, and user can define varibles in qss.
- [qsseditor](https://github.com/HappySeaFox/qsseditor) - Cross-platform application to edit and preview Qt style sheets (QSS). 
- [CANdevStudio](https://github.com/GENIVI/CANdevStudio) - Development tool for CAN bus simulation
- [Scrite](https://github.com/teriflix/scrite) - QML Crossplatform Screenwriting Software
- [Qt3DExaminerViewer](https://github.com/HSF/Qt3DExaminerViewer) - A viewer module which offers manipulation and visualization functionalities and tools similar to the OpenInventor/Coin Examiner viewer.
- [Mayo](https://github.com/fougue/mayo) - 3D CAD viewer and converter based on Qt + OpenCascade
- [PlotJuggler](https://github.com/facontidavide/PlotJuggler) - PlotJuggler is a Qt + QWT based tool to visualize time series that is fast, powerful and intuitive.

## Raspberry Pi

- [QtRpi](https://github.com/neuronalmotion/qtrpi)- An easy-to-use environment to cross-compile Qt applications for Raspberry Pi from your desktop.

## Robotics

- [URSim_Install_Guides 16.04](https://github.com/githubuser0xFFFF/URSim_Install_Guides) - Collection of installation guides for Universal Robots URSim simulation environment
- [URSim_Install_Guides 18.04](https://github.com/ljden/URSim_Install_Guides) - Basic installation guide for URSim on Ubuntu 18.04
- [ROS Industrial Training](https://github.com/ros-industrial/industrial_training) - ROS-Industrial Training Material
- [Universal_Robots_ROS_Driver](https://github.com/UniversalRobots/Universal_Robots_ROS_Driver) - Driver enabling ROS operation of UR robots.
- [pyrobosim](https://github.com/tioguerra/pyrobosim) - A simple robot simulator written in Python using ODE for physics and VTK for visualization 
- [rbdl-toolkit](https://github.com/ORB-HD/rbdl-toolkit) - Application for visualizing and working with rbdl models 
- [Robot_Arm_Kinematics_Lib](https://github.com/RobinCPC/Robot_Arm_Kinematics_Lib) - A kinematic Library for 6-axis Articulated Robot Arm 
- [mc_rtc](https://github.com/jrl-umi3218/mc_rtc) - mc_rtc is an interface for simulated and real robotic systems suitable for real-time control
- [Skynet_Robot_Control_Rtos_Ethercat](https://github.com/githubuser0xFFFF/Skynet_Robot_Control_Rtos_Ethercat) - Realtime 6-axis robot controller, based on Qt C++ & OpenCascade & KDL kinematics & HAL 
- [roboticslibrary](https://github.com/roboticslibrary/rl) - The Robotics Library (RL) is a self-contained C++ library for rigid body kinematics and dynamics, motion planning, and control.
- [python-urx](https://github.com/SintefManufacturing/python-urx) - Python library to control a robot from 'Universal Robots' http://www.universal-robots.com/ 
- [Awesome Robotics Libraries](https://github.com/jslee02/awesome-robotics-libraries) - A curated list of robotics simulators and libraries.
- [orocos_kdl - Kinematics and Dynamics Library](https://github.com/orocos/orocos_kinematics_dynamics) - Orocos project to supply RealTime usable kinematics and dynamics code, it contains code for rigid body kinematics calculations and representations for kinematic structures and their inverse and forward kinematic solvers.

## C / C++

- [Conan](https://github.com/conan-io/conan) - The open-source C/C++ package manager
- [Jinja2Cpp](https://github.com/jinja2cpp/Jinja2Cpp) - Jinja2 C++ (and for C++) almost full-conformance template engine implementation
- [inja](https://github.com/pantor/inja) - A Template Engine for Modern C++
- [awesome-modern-cpp](https://github.com/rigtorp/awesome-modern-cpp) - A collection of resources on modern C++
- [pprint](https://github.com/p-ranav/pprint) - Pretty Printer for Modern C++
- [tinyformat](https://github.com/c42f/tinyformat) - Minimal, type safe printf replacement library for C++
- [libserialport](https://github.com/sigrokproject/libserialport) - Read-only mirror of the official repo at git://sigrok.org/libserialport.
- [json](https://github.com/nlohmann/json) - JSON for Modern C++ 
- [boost::archive::json*](https://github.com/briancairl/boost_archive_json) - This library provides JSON input/output archive objects usable with [boost serialization](https://www.boost.org/doc/libs/1_71_0/libs/serialization/doc/serialization.html) module.
- [Timer](https://github.com/Baduit/Timer) - A simple C++ header-only library to use cross-platform timer functionnalities using only the standard library. 
- [log4cplus](https://github.com/log4cplus/log4cplus) - log4cplus is a simple to use C++ logging API providing thread-safe, flexible, and arbitrarily granular control over log management and configuration. It is modelled after the Java log4j API.
- [cereal](https://github.com/USCiLab/cereal) - A C++11 library for serialization  
- [csv-parser](https://github.com/vincentlaucsb/csv-parser) - A modern C++ library for reading, writing, and analyzing CSV (and similar) files. 
- [csv2](https://github.com/p-ranav/csv2) - Fast CSV parser and writer for Modern C++ 
- [rapidcsv](https://github.com/d99kris/rapidcsv) - The goal of rapidcsv is to be an easy-to-use CSV library enabling rapid development
- [CppVerbalExpressions](https://github.com/VerbalExpressions/CppVerbalExpressions) - C++ regular expressions made easy 
- [modern-cpp-features](https://github.com/AnthonyCalandra/modern-cpp-features) - A cheatsheet of modern C++ language and library features. 
- [expected-lite](https://github.com/martinmoene/expected-lite) - Expected objects in C++11 and later in a single-file header-only library
- [sigslot](https://github.com/palacaze/sigslot) - Sigslot is a header-only C++14, thread safe implementation of signal-slots for C++
- [delegates](https://github.com/marcmo/delegates) - small delegate implementation 
- [type_safe](https://github.com/foonathan/type_safe) - Zero overhead utilities for preventing bugs at compile time
- [nanobench](https://github.com/martinus/nanobench) - Simple, fast, accurate single-header microbenchmarking functionality for C++11/14/17/20 
- [meta](https://github.com/skypjack/meta) - Header-only, non-intrusive and macro-free runtime reflection system in C++ 
- [doctest](https://github.com/onqtam/doctest) - The fastest feature-rich C++11/14/17/20 single-header testing framework 
- [PlusCallback](https://github.com/codeplea/pluscallback) - PlusCallback is a C++ library, contained in a single header file, that implements easy to use function and method callbacks.
- [TinyFSM](https://github.com/digint/tinyfsm) - TinyFSM is a simple finite state machine library for C++, designed for optimal performance and low memory footprint. This makes it ideal for real-time operating systems. 
- [Cranium](https://github.com/100/Cranium) - A portable, header-only, artificial neural network library written in C99 
- [clipp](https://github.com/muellan/clipp) - Easy to use, powerful & expressive command line argument parsing for modern C++ / single header / usage & doc generation 
- [frugally-deep](https://github.com/Dobiasd/frugally-deep) - Header-only library for using Keras models in C++
- [indicators](https://github.com/p-ranav/indicators) - Activity Indicators for command line for Modern C++ 
- [KFR](https://github.com/kfrlib/kfr) - Fast, modern C++ DSP framework
- [Magic Enum C++](https://github.com/Neargye/magic_enum) - Static reflection for enums (to string, from string, iteration) for modern C++, work with any enum type without any macro or boilerplate code 
- [Better Enums](https://github.com/aantron/better-enums) - C++ compile-time enum to string, iteration, in a single header file 
- [FunctionalPlus](https://github.com/Dobiasd/FunctionalPlus) - Functional Programming Library for C++. Write concise and readable C++ code. 
- [cpp-httplib](https://github.com/yhirose/cpp-httplib) - A C++ header-only HTTP/HTTPS server and client library 
- [Taskflow](https://github.com/taskflow/taskflow) - A General-purpose Parallel and Heterogeneous Task Programming System 
- [atomic_queue](https://github.com/max0x7ba/atomic_queue) - C++ lockless queue. 
- [Units](https://github.com/LLNL/units) - A run-time C++ library for working with units of measurement and conversions between them and with string representations of units and measurements 
- [polymorphic_value](https://github.com/jbcoe/polymorphic_value) - A polymorphic value-type for C++
- [Tiny-utf8 ](https://github.com/DuffsDevice/tiny-utf8) - Tiny-utf8 is a library for extremely easy integration of Unicode into an arbitrary C++11 project.
- [Backward-cpp](https://github.com/bombela/backward-cpp) - Backward is a beautiful stack trace pretty printer for C++.
- [spdlog](https://github.com/gabime/spdlog) - Very fast, header-only/compiled, C++ logging library.
- [https://github.com/fnc12/sqlite_orm](https://github.com/fnc12/sqlite_orm) - SQLite ORM light header only library for modern C++. sqlite_orm library allows to create easy data model mappings to your database schema.

## Python

- [fastapi](https://github.com/Opentrons/fastapi) - FastAPI framework, high performance, easy to learn, fast to code, ready for production

## Software Development

- [tableau-log-viewer](https://github.com/tableau/tableau-log-viewer) - Tableau Log Viewer is a cross-platform tool for quickly glancing over Tableau log files
- [fluentui-system-icons ](https://github.com/microsoft/fluentui-system-icons) - Fluent System Icons are a collection of familiar, friendly and modern icons from Microsoft.
- [doxygen-awesome-css](https://github.com/jothepro/doxygen-awesome-css) - Custom CSS theme for doxygen html-documentation with lots of customization parameters. 
- [svg-explorer-extension](https://github.com/tibold/svg-explorer-extension) - Extension module for Windows Explorer to render SVG thumbnails, so that you can have an overview of your SVG files 
- [install-qt-action](https://github.com/jurplel/install-qt-action) - Install Qt on your Github Actions workflows with just one simple action 
- [gRPC](https://github.com/grpc/grpc) - gRPC is a modern, open source, high-performance remote procedure call (RPC) framework that can run anywhere. 

## Embedded

- [modm](https://github.com/modm-io/modm) - A C++20 library generator for AVR and ARM Cortex-M devices
- [erpc](https://github.com/EmbeddedRPC/erpc) - Embedded RPC
- [pybricks-micropython](https://github.com/pybricks/pybricks-micropython) - MicroPython firmware for Pybricks-compatible devices. 
- [AvrLib](https://github.com/jypma/AvrLib) - Highly type-safe modern C++ library for AVR 
- [ETL](https://github.com/ETLCPP/etl) - Embedded Template Library. The ETL is not designed to completely replace the STL, but complement it. 

## SiLA

- [ot2-controller](https://github.com/FlorianBauer/ot2-controller) - A SiLA 2 compliant controller for an Opentrons OT-2 liquid handling robot. 
- [panda-controller](https://github.com/FlorianBauer/panda-controller) - A SiLA 2 compliant controller for an Franka Emika Panda robot arm.
- [sila-orchestrator](https://github.com/FlorianBauer/sila-orchestrator) - A simple, dynamic SiLA 2 client for coordinating various services. 

## 3D
- [Open3D](https://github.com/isl-org/Open3D) - Open3D is an open-source library that supports rapid development of software that deals with 3D data. 